<?php
/*
* PAGINA DE CONFIGURACION DE PARAMETROS PARA PAYPALS MANAGER
*/
defined( 'ABSPATH' ) || exit;

initial_config();//configuracion inicial al instalar servidor pp_server_id = 1; _paypal_options = _SSNA
add_action( 'admin_menu', 'paypal_server_submenu');
 
/*
  __    _____                                                     
 /_ |  / ____|                                                    
  | | | (___     ___ _ __ ___  __ _ _ __   _ __   __ _  __ _  ___ 
  | |  \___ \   / __| '__/ _ \/ _` | '__| | '_ \ / _` |/ _` |/ _ \
  | |  ____) | | (__| | |  __/ (_| | |    | |_) | (_| | (_| |  __/
  |_| |_____/   \___|_|  \___|\__,_|_|    | .__/ \__,_|\__, |\___|
                                          | |           __/ |     
                                          |_|          |___/      
* Agrega un submenú de configuración
* PARAMETROS: 
* add_submenu_page( string $parent_slug, string $page_title, string $menu_title, 
* string $capability, string $menu_slug, callable $callback = '', int|float $position = null ):string|false
*/
{//grupo lectura
function paypal_server_submenu(){
	//					parentSlug					title				menutit			capacidad			slug	funcion  position
	add_submenu_page('edit.php?post_type=paypals','Historial de cambios','Historial de cambios','ver_paypals','pp_changes_history','paypal_change_history_page',3000);//Las funciones se encuentran en paypal_entry_point.php
	add_submenu_page('edit.php?post_type=paypals','Configurar servidor','Configurar servidor','ver_paypals','pp_server_config','paypal_server_settings_page',200);
	//PAYPALsettings
	//add_submenu_page('paypal_config', 'Paypal configuration', 'Paypal configuration', 'ver_paypals', 'paypal_config1', 'paypal_client_settings_page');
}
function paypal_server_settings_page(){
	echo '<div class="config">';
	echo "<form action='options.php' method='post'>";
	settings_fields('_paypal_options'); //Carga lo definido en register_setting(). Los updates?
	do_settings_sections('paypal_server_fields'); //Muestra los inputs definidos con add_settings_section
	echo "<input name='submit' class='button button-primary' type='submit' value='Save' />";
	echo "<hr>";
	echo "</form>";
	echo '</div>';
} // function wao_settings_page() END

}//grupo lectura
/*
  ___     _____                  _     _                       _   _   _                 
 |__ \   / ____|                (_)   | |                     | | | | (_)                
    ) | | (___    _ __ ___  __ _ _ ___| |_ ___ _ __   ___  ___| |_| |_ _ _ __   __ _ ___ 
   / /   \___ \  | '__/ _ \/ _` | / __| __/ _ \ '__| / __|/ _ \ __| __| | '_ \ / _` / __|
  / /_   ____) | | | |  __/ (_| | \__ \ ||  __/ |    \__ \  __/ |_| |_| | | | | (_| \__ \
 |____| |_____/  |_|  \___|\__, |_|___/\__\___|_|    |___/\___|\__|\__|_|_| |_|\__, |___/
                            __/ |                                               __/ |    
                           |___/                                               |___/     
* REGISTRANDO LOS CAMPOS O VARIABLES EN LA BASE DE DATOS [PASO 1]
*/
{//grupo lectura
function register_paypal_server_settings() {
	// REGISTRAMOS UNA PAGINA DE CONFIGURACION
	//                     option_group        option_name   array args (funcion de validacion)
	register_setting( '_paypal_options', '_paypal_options', '_paypal_options_validate' );
	$tituloseccion = "<div style='text-align:center;background-color:#e6f2ff;padding:30px;border:solid 1px white'>Paypals server</div>";
	// CREAMOS UNA SECCION DENTRO LA PAGINA DE CONFIGURACION CON $tituloseccion y el subtitulo html en una funcion
	//                          id             titulo                      funcion                			pagina
	add_settings_section( 'paypal1_settings', $tituloseccion, 'paypals_plugin_configuration_page_title', 'paypal_server_fields' );
	// INSERTAMOS CADA INPUT, MEDIANTE UNA FUNCION EXTERNA.
	// Por cada uno, hay una función separada para insertar un input.
	//                          id                         title                                               funcion                   page         seccion
	add_settings_field( 'paypal_setting_multiple_countries', 'Paypals para multiples sitios', 'paypal_setting_multiple_countries', 'paypal_server_fields', 'paypal1_settings' );
	add_settings_field( 'paypal_setting_checkout', 'Paypal checkout activo', 'paypal_setting_checkout', 'paypal_server_fields', 'paypal1_settings' );
	add_settings_field( 'paypal_setting_payments', 'Paypal payments activo', 'paypal_setting_payments', 'paypal_server_fields', 'paypal1_settings' );
	add_settings_field( 'paypal_setting_diasborrar', 'Nro. de dias que paypals "En revision" serán conservados.','paypal_setting_diasborrar', 'paypal_server_fields', 'paypal1_settings' );
	add_settings_field( 'paypal_setting_subdirectorio', 'Subdirectorio (ej: /country)','paypal_setting_subdirectorio', 'paypal_server_fields', 'paypal1_settings' );
	
}
add_action( 'admin_init', 'register_paypal_server_settings' );
/////VALIDACION
function _paypal_options_validate( $input ) {
	$newinput['urlmanuals'] = trim( $input['urlmanuals'] );
	if ( ! preg_match( '/^[a-z0-9]{32}$/i', $newinput['urlmanuals'] ) ) {
		$newinput['urlmanuals'] = '';
	}
	//return $newinput;
	return $input;
}
}//grupo lectura
/*
  ____     _____   _             _                   _       
 |___ \   / ____| | |           (_)                 | |      
   __) | | (___   | | ___  ___   _ _ __  _ __  _   _| |_ ___ 
  |__ <   \___ \  | |/ _ \/ __| | | '_ \| '_ \| | | | __/ __|
  ___) |  ____) | | | (_) \__ \ | | | | | |_) | |_| | |_\__ \
 |____/  |_____/  |_|\___/|___/ |_|_| |_| .__/ \__,_|\__|___/
                                        | |                  
                                        |_|                  

*/
//////////LOS CAMPOS DEL FORMULARIO, LOS QUE SE VEN [PASO 2]
{//grupo para facilitar la lectura
function paypals_section_text() {
	echo '<p>Configuracion de Parametros como servidor paypals.</p>';
}
function paypals_plugin_configuration_page_title() {
	echo '<h3>Configuraci&oacute;n de parametros como servidor paypals.</h3>';
}
function paypal_setting_multiple_countries() { // Solo se muestra y valida si es multisite
	if(is_multisite()){
		$options = get_option( '_paypal_options' );
		$checked = $options['multiple_countries']=="M"?"checked":"";
		echo '<input type="radio" id="paypal_multiple_countries" name="_paypal_options[multiple_countries]" value="M" '.$checked.'><label for="multiple_countries">Multiple</label>&nbsp;&nbsp;&nbsp;'; 
		$checked = $options['multiple_countries']=="S"?"checked":"";
		echo '<input type="radio" id="paypal_multiple_countries" name="_paypal_options[multiple_countries]" value="S" '.$checked.'><label for="multiple_countries">Single</label>'; 
	}else{
		echo '<input type="hidden" id="paypal_multiple_countries" name="_paypal_options[multiple_countries]" value="S" >'; 
	}
}
function paypal_setting_checkout() { // Combos (COMBO#SKU|ID*ID)
	$options = get_option( '_paypal_options' );
	$checked = $options['checkout']=="S"?"checked":"";
	echo '<input type="radio" id="paypal_checkout" name="_paypal_options[checkout]" value="S" '.$checked.'><label for="checkout">Si</label>&nbsp;&nbsp;&nbsp;'; 
	$checked = $options['checkout']=="N"?"checked":"";
	echo '<input type="radio" id="paypal_checkout" name="_paypal_options[checkout]" value="N" '.$checked.'><label for="checkout">No</label>&nbsp;&nbsp;&nbsp;'; 
	echo "<span style='color:gray;font-size:11px;font-style: italic;'>Activo muestra en el ABM de paypals</span>";
}
function paypal_setting_payments() { // Combos (COMBO#SKU|ID*ID)
	$options = get_option( '_paypal_options' );
	$checked = $options['payments']=="S"?"checked":"";
	echo '<input type="radio" id="paypal_payments" name="_paypal_options[payments]" value="S" '.$checked.'><label for="payments">Si</label>&nbsp;&nbsp;&nbsp;'; 
	$checked = $options['payments']=="N"?"checked":"";
	echo '<input type="radio" id="paypal_payments" name="_paypal_options[payments]" value="N" '.$checked.'><label for="payments">No</label>&nbsp;&nbsp;&nbsp;'; 
	echo "<span style='color:gray;font-size:11px;font-style: italic;'>Activo muestra en el ABM de paypals</span>";
}
function paypal_setting_diasborrar() { 
	// otra opcion es usar la funcion woocommerce_wp_text_input
	$options = get_option( '_paypal_options' );
	$dias = esc_attr( $options['diasborrar'] );
	if(empty($dias)){$dias=100;}
	echo "<input id='paypal_setting_subdirectorio' name='_paypal_options[diasborrar]' type='number' placeholder='100' value='".$dias."' /> ";
	echo "<span><i style='margin-left:0px;'>(Los paypals con estado 'En Revision' no modificados en los ultimos X dias, serán eliminados.)</i></span>";
}
function paypal_setting_subdirectorio() { // 
  $options = get_option( '_paypal_options' );
  echo "<input id='paypal_setting_subdirectorio' name='_paypal_options[subdirectorio]' type='text' value='".esc_attr( $options['subdirectorio'] )."' /> ";
  echo "<i style='margin-left:20px;'>(Usar cuando la subtienda esta bajo subdirectorio)</i>";
  paypal_setting_hiddens_server();
}
function paypal_setting_hiddens_server(){
	$paypal_old_options=get_paypal_options();
	if(is_bool($paypal_old_options)||$paypal_old_options==""){//por defecto si cambiando de servidor, no cuenta con config
		$paypal_old_options=array('periodsales'=>'A','urlmanuals'=>'');
	}
	echo "<input type='hidden' id='paypal_setting_periodsales' name='_paypal_options[periodsales]' value='".$paypal_old_options['periodsales']."'>";
	echo "<input type='hidden' id='paypal_setting_urlmanuals' name='_paypal_options[urlmanuals]' value='".$paypal_old_options['urlmanuals']."'>";
}
          
}//grupo para facilitar lectura  

//borrar
/**
 * Class to log warnings.
 */
class Log_Warning {
	private string $message;
	public function __construct( string $message ) {$this->message = $message; add_action( 'admin_notices', array( $this, 'render' ) );}
	public function render() { printf( '<div class="notice notice-alert id-dismissible"><p>Warning: %s</p></div>', esc_html( $this->message ) );}
}
function my_alert3(){
	$message = "<p>El paypal cambiado, a&uacute; est&aacute; activo en otros shops!</p><p>Se debe revisar en cada uno de ellos.</p>";	
	echo "<div class='notice notice-alert id-dismissible'>";	
	echo $message;	
	echo "</div>";	
}


